// ===== SIDEBAR FUNCTIONALITY =====
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const mainContent = document.querySelector('.main-content');
    const header = document.querySelector('.header');

    // Use the same mobile breakpoint as the CSS (768px)
    if (window.innerWidth <= 768) {
        // Mobile: slide-in behavior — CSS uses .active
        sidebar?.classList.toggle('active');
        overlay?.classList.toggle('active');
    } else {
        // Desktop: collapse the sidebar to a compact width
        // Add/remove a `collapsed` class that the stylesheet can use
        sidebar?.classList.toggle('collapsed');
        mainContent?.classList.toggle('sidebar-collapsed');
        header?.classList.toggle('sidebar-collapsed');
    }
}

function closeSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    
    sidebar?.classList.remove('show');
    overlay?.classList.remove('show');
}



// // notification


        // Add this to your existing script section
        const notificationIcon = document.querySelector('.notification-icon');
        const notificationPopup = document.querySelector('.notification-popup');

        // Toggle notification popup on bell icon click
        notificationIcon.addEventListener('click', (e) => {
            notificationPopup.classList.toggle('show');
            e.stopPropagation(); // Prevent click from bubbling to document
        });

        // Close notification popup when clicking outside
        document.addEventListener('click', (e) => {
            if (!notificationIcon.contains(e.target)) {
                notificationPopup.classList.remove('show');
            }
        });

        // Close notification popup on escape key
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') {
                notificationPopup.classList.remove('show');
            }
        });
     
        
    // utility to show/hide the centered toast modal
    function showToastModal(message = 'Notifications cleared') {
        const overlay = document.getElementById('notificationToastOverlay');
        const msg = document.getElementById('notificationToastMessage');
        if (!overlay || !msg) return;
        msg.textContent = message;
        overlay.hidden = false;
        // small delay to allow CSS transition
        requestAnimationFrame(() => overlay.classList.add('visible'));
    }

    function hideToastModal() {
        const overlay = document.getElementById('notificationToastOverlay');
        if (!overlay) return;
        overlay.classList.remove('visible');
        // wait for transition then hide element for accessibility
        setTimeout(() => overlay.hidden = true, 210);
    }

    // Clear All handler — keep popup open, update list/count, then show modal
    const btnClearAll = document.querySelector('.btn-clear-all');
    const notificationList = document.querySelector('.notification-list');
    const notificationBadge = document.querySelector('.notification-badge');
    const notificationCount = document.querySelector('.notification-count');
    const notificationPopupp = document.querySelector('.notification-popup');

    if (btnClearAll) {
        btnClearAll.addEventListener('click', (e) => {
            e.stopPropagation(); // keep popup open

            if (notificationList) {
                notificationList.innerHTML = `
                    <div class="notification-item notification-empty">
                        <div class="notification-content">
                            <div class="notification-title">You're all caught up</div>
                            <div class="notification-text">No new notifications</div>
                        </div>
                    </div>
                `;
            }

            if (notificationCount) notificationCount.textContent = '0 New';
            if (notificationBadge) notificationBadge.style.display = 'none';
            if (notificationPopupp) notificationPopupp.classList.add('show');

            // show separate centered toast modal
            showToastModal('Notifications cleared');
        });
    }

    // OK button closes the modal
    const notificationToastOk = document.getElementById('notificationToastOk');
    if (notificationToastOk) {
        notificationToastOk.addEventListener('click', (e) => {
            e.stopPropagation();
            hideToastModal();
        });
    }

    // prevent clicks on overlay from closing — keep modal controlled by OK only
    const notificationOverlay = document.getElementById('notificationToastOverlay');
    if (notificationOverlay) {
        notificationOverlay.addEventListener('click', (e) => {
            // do nothing so clicking overlay does NOT close the modal
            e.stopPropagation();
        });
    }

        // Add this to your existing script section
        function toggleProfileDropdown(e) {
            e.stopPropagation();
            const dropdown = document.querySelector('.profile-dropdown');
            dropdown.classList.toggle('show');
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', () => {
            const dropdown = document.querySelector('.profile-dropdown');
            if (dropdown.classList.contains('show')) {
                dropdown.classList.remove('show');
            }
        });

        // Prevent dropdown from closing when clicking inside it
        document.querySelector('.profile-dropdown').addEventListener('click', (e) => {
            e.stopPropagation();
        });


        // products catalogue star

        document.addEventListener('DOMContentLoaded', function() {
            const starRatings = document.querySelectorAll('.star-rating');
            
            starRatings.forEach(rating => {
                const star = rating.querySelector('i');
                
                star.addEventListener('click', function(e) {
                    e.stopPropagation();
                    
                    // Toggle filled state
                    if (this.classList.contains('filled')) {
                        this.classList.remove('filled', 'fas');
                        this.classList.add('far');
                        rating.setAttribute('data-rating', '0');
                    } else {
                        this.classList.remove('far');
                        this.classList.add('filled', 'fas');
                        rating.setAttribute('data-rating', '1');
                    }
                });
            });
        });


        // subscription page activity

 document.addEventListener('DOMContentLoaded', function() {
            let currentPopover = null; // Track currently open popover
            let currentActiveTab = 'todo'; // Track active tab

            // Popover content
            const createPopoverContent = () => {
                return `
                    <div class="popover-content-link">
                        <p class="activity-description">Schedule activities to help you get things done.</p>
                        <div class="schedule-button">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                            </svg>
                            <span>Schedule an activity</span>
                        </div>
                    </div>
                `;
            };

            // Initialize popover for all clock icons
            const clockIcons = document.querySelectorAll('.clock-icon');
            
            clockIcons.forEach((clockIcon) => {
                const popover = new bootstrap.Popover(clockIcon, {
                    trigger: 'click',
                    html: true,
                    content: createPopoverContent(),
                    title: 'Demo Company',
                    placement: 'bottom',
                    sanitize: false
                });

                // Handle popover shown event
                clockIcon.addEventListener('shown.bs.popover', function() {
                    // Close previous popover if exists
                    if (currentPopover && currentPopover !== clockIcon) {
                        const prevPopoverInstance = bootstrap.Popover.getInstance(currentPopover);
                        if (prevPopoverInstance) {
                            prevPopoverInstance.hide();
                        }
                    }
                    
                    // Update current popover
                    currentPopover = clockIcon;

                    // Add click event to schedule button
                    const popoverElement = document.querySelector('.popover');
                    if (popoverElement) {
                        const scheduleButton = popoverElement.querySelector('.schedule-button');
                        if (scheduleButton) {
                            scheduleButton.addEventListener('click', function(e) {
                                e.stopPropagation();
                                
                                // Close the popover first
                                const popoverInstance = bootstrap.Popover.getInstance(clockIcon);
                                if (popoverInstance) {
                                    popoverInstance.hide();
                                    currentPopover = null;
                                }
                                
                                // Open the custom modal
                                openActivityModal();
                            });
                        }

                        // Prevent popover from closing when clicking inside
                        popoverElement.addEventListener('click', function(e) {
                            e.stopPropagation();
                        });
                    }
                });

                // Handle click on clock icon
                clockIcon.addEventListener('click', function(e) {
                    e.stopPropagation();
                    
                    // If clicking the same icon that's already open, close it
                    if (currentPopover === clockIcon) {
                        const popoverInstance = bootstrap.Popover.getInstance(clockIcon);
                        if (popoverInstance) {
                            popoverInstance.hide();
                            currentPopover = null;
                        }
                    }
                });
            });

            // Close popover when clicking outside
            document.addEventListener('click', function(e) {
                if (!e.target.closest('.clock-icon') && !e.target.closest('.popover')) {
                    if (currentPopover) {
                        const popoverInstance = bootstrap.Popover.getInstance(currentPopover);
                        if (popoverInstance) {
                            popoverInstance.hide();
                            currentPopover = null;
                        }
                    }
                }
            });

            // Custom Modal Functions
            function openActivityModal() {
                const modal = document.getElementById('customActivityModal');
                modal.style.display = 'flex';
                setTimeout(() => {
                    modal.classList.add('active');
                }, 10);
                
                // Reset to To-Do tab
                switchTab('todo');
            }

            function closeActivityModal() {
                const modal = document.getElementById('customActivityModal');
                modal.classList.remove('active');
                setTimeout(() => {
                    modal.style.display = 'none';
                }, 300);
            }

            // Tab switching function
            function switchTab(tabName) {
                currentActiveTab = tabName;
                
                // Remove active class from all tabs
                document.querySelectorAll('.activity-tab').forEach(tab => {
                    tab.classList.remove('active');
                });
                
                // Add active class to clicked tab
                document.querySelector(`[data-tab="${tabName}"]`).classList.add('active');
                
                // Update summary field label based on tab
                const summaryLabel = document.getElementById('summaryLabel');
                const summaryInput = document.getElementById('summaryInput');
                
                switch(tabName) {
                    case 'todo':
                        summaryLabel.textContent = 'Summary';
                        summaryInput.placeholder = 'To-Do';
                        break;
                    case 'email':
                        summaryLabel.textContent = 'Summary';
                        summaryInput.placeholder = 'Email';
                        break;
                    case 'call':
                        summaryLabel.textContent = 'Summary';
                        summaryInput.placeholder = 'Call';
                        break;
                    case 'meeting':
                        summaryLabel.textContent = 'Summary';
                        summaryInput.placeholder = 'Meeting';
                        break;
                    case 'document':
                        summaryLabel.textContent = 'Summary';
                        summaryInput.placeholder = 'Document';
                        break;
                    case 'signature':
                        summaryLabel.textContent = 'Summary';
                        summaryInput.placeholder = 'Signature';
                        break;
                }
                
                // Show/hide center icon based on tab
                const centerIcon = document.getElementById('centerIcon');
                if (tabName === 'meeting') {
                    centerIcon.style.display = 'flex';
                } else {
                    centerIcon.style.display = 'none';
                }
                
                // Update footer buttons
                document.querySelectorAll('.footer-buttons').forEach(btnGroup => {
                    btnGroup.classList.remove('active');
                });
                
                if (tabName === 'todo') {
                    document.getElementById('todo-buttons').classList.add('active');
                } else if (tabName === 'meeting') {
                    document.getElementById('meeting-buttons').classList.add('active');
                } else {
                    document.getElementById('default-buttons').classList.add('active');
                }
            }

            // Tab click events
            document.querySelectorAll('.activity-tab').forEach(tab => {
                tab.addEventListener('click', function() {
                    const tabName = this.getAttribute('data-tab');
                    switchTab(tabName);
                });
            });

            // Close modal on overlay click
            document.getElementById('customActivityModal').addEventListener('click', function(e) {
                if (e.target === this) {
                    closeActivityModal();
                }
            });

            // Close button
            document.getElementById('closeModalBtn').addEventListener('click', closeActivityModal);

            // Discard buttons
            document.querySelectorAll('.btn-discard').forEach(btn => {
                btn.addEventListener('click', closeActivityModal);
            });

            // Save button for To-Do
            document.getElementById('saveToDoBtn').addEventListener('click', function() {
                const summary = document.getElementById('summaryInput').value;
                const dueDate = document.getElementById('dueDateInput').value;
                const assignedTo = document.getElementById('assignedToInput').value;
                const notes = document.getElementById('notesInput').value;
                
                console.log('Activity saved:', { type: currentActiveTab, summary, dueDate, assignedTo, notes });
                
                closeActivityModal();
                showSuccessMessage('Activity saved successfully!');
                
                // Reset form
                document.getElementById('summaryInput').value = '';
                document.getElementById('dueDateInput').value = '';
                document.getElementById('assignedToInput').value = '';
                document.getElementById('notesInput').value = '';
            });

            // Mark Done button for To-Do
            document.getElementById('markDoneBtn').addEventListener('click', function() {
                console.log('Activity marked as done');
                closeActivityModal();
                showSuccessMessage('Activity marked as done!');
            });

            // Schedule button for Meeting
            document.getElementById('scheduleMeetingBtn').addEventListener('click', function() {
                const summary = document.getElementById('summaryInput').value;
                const dueDate = document.getElementById('dueDateInput').value;
                const assignedTo = document.getElementById('assignedToInput').value;
                const notes = document.getElementById('notesInput').value;
                
                console.log('Meeting scheduled:', { summary, dueDate, assignedTo, notes });
                
                closeActivityModal();
                showSuccessMessage('Meeting scheduled successfully!');
                
                // Reset form
                document.getElementById('summaryInput').value = '';
                document.getElementById('dueDateInput').value = '';
                document.getElementById('assignedToInput').value = '';
                document.getElementById('notesInput').value = '';
            });

            // Success message function
            function showSuccessMessage(message) {
                const successDiv = document.createElement('div');
                successDiv.className = 'success-toast';
                successDiv.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"></path>
                        <polyline points="22 4 12 14.01 9 11.01"></polyline>
                    </svg>
                    <span>${message}</span>
                `;
                document.body.appendChild(successDiv);
                
                setTimeout(() => {
                    successDiv.classList.add('show');
                }, 10);
                
                setTimeout(() => {
                    successDiv.classList.remove('show');
                    setTimeout(() => {
                        successDiv.remove();
                    }, 300);
                }, 3000);
            }

            // Make functions global
            window.closeActivityModal = closeActivityModal;
            window.switchTab = switchTab;
        });



        //  currecncy symbol change

         // Currency symbol mapping
        const currencySymbols = {
            'SAR': '&#xEA;',  // Saudi Riyal symbol
            'AED': 'د.إ',      // UAE Dirham symbol
            'EUR': '€'         // Euro symbol
        };

        // Get the select element
        const currencySelect = document.getElementById('currencySelect');

        // Function to update all currency symbols
        function updateCurrencySymbols(currency) {
            // Get all elements with class 'currency-symbol'
            const symbolElements = document.querySelectorAll('.currency-symbol');
            
            // Get the symbol for the selected currency
            const symbol = currencySymbols[currency];
            
            // Update all currency symbols on the page
            symbolElements.forEach(element => {
                element.innerHTML = symbol;
            });
        }

        // Add event listener to the select dropdown
        currencySelect.addEventListener('change', function() {
            updateCurrencySymbols(this.value);
        });

        // Initialize with default currency (SAR)
        updateCurrencySymbols('SAR');


// log note section

function switchTab(tabName) {
            // Remove active class from all tabs
            document.querySelectorAll('.log-note-section .nav-tab-item').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Hide all content areas
            document.querySelectorAll('.log-note-section .content-area').forEach(content => {
                content.classList.remove('active');
            });
            
            // Add active class to clicked tab (if not Activity)
            if (tabName !== 'activity') {
                event.target.classList.add('active');
                
                // Show corresponding content
                document.getElementById(tabName + '-content').classList.add('active');
            }
        }

        function openActivityModal() {
            const modal = new bootstrap.Modal(document.getElementById('activityModal'));
            modal.show();
        }

